/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.CrystalStationContainer;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.SkillUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrystalStationBlock
extends BaseBlock {
    private static final ITextComponent TITLE = new TranslationTextComponent("screen.crystal_station");

    public CrystalStationBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.6f).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_235861_h_().func_226896_b_());
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return new SimpleNamedContainerProvider((windowId, inventory, player) -> new CrystalStationContainer(windowId, inventory), TITLE);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            IPlayerData data = PlayerData.getUnsafe(player);
            IPerkProvider perkProvider = data.getPerkProvider();
            ISkillProvider provider = data.getSkillProvider();
            if (perkProvider.isOnCooldown()) {
                int cooldown = perkProvider.getCooldown();
                String formattedCooldown = Interval.format(cooldown, format -> format.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND));
                ((ServerPlayerEntity)player).func_241151_a_((ITextComponent)new TranslationTextComponent("crystal.station.on_cooldown", new Object[]{formattedCooldown}), ChatType.GAME_INFO, Util.field_240973_b_);
                return ActionResultType.CONSUME;
            }
            if (!provider.hasSkill(Skills.CRYSTAL_STATION)) {
                ((ServerPlayerEntity)player).func_241151_a_(SkillUtil.getMissingSkillText(Skills.CRYSTAL_STATION), ChatType.GAME_INFO, Util.field_240973_b_);
                return ActionResultType.CONSUME;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }
}

